//    variant.cpp - support for Delphi variants in C++
//
//    1.2
//    2002/01/02 19:50:31
//
//    Copyright (c) 1997, 2002 Borland Software Corporation


#include <System.hpp>
#include <VarUtils.hpp>
#include <VarHlpr.hpp>
#include <string.h>
#include <limits.h>

#if defined(VARIANT_AUTOMATION_SUPPORT)
  #pragma message FIXME: this is kind of bogus. see Variants::Raise* functions
  #include <variant.hpp>
#endif

#define Varhlpr Varhlpr

#if defined(_Windows)
  #include <oaidl.h>
  #include <comobj.hpp>
  #include <oleauto.h>
#endif

#include <Variants.hpp>
#ifdef VARIANT_TVARIANT_SUPPORT
  #include <utilcls.h>
#endif

#ifndef _ASSERTE
  #include <assert.h>
  #define _ASSERTE(x) assert(x)
#endif

#if !defined(VARIANT_NATIVE_SUPPORT)
  const BOOL VARIANT_FALSE = 0;
  const BOOL VARIANT_TRUE = 65535;
#endif // VARIANT_NATIVE_SUPPORT

// Treat 'long' as either a 32-bit or 64-bit type as appropriate
#if defined(_LP64) || sizeof(long) * CHAR_BITS == 8
  #define Variant_varLong varInt64
  #define Variant_varULong varInt64
  #define Variant_VLong VInt64
  #define Variant_VULong VInt64
#else
  #define Variant_varLong varInteger
  #define Variant_varULong varLongWord
  #define Variant_VLong VInteger
  #define Variant_VULong VLongWord
#endif


// FIXME: remove this macro and fix everything up once the need for it
// is understood and/or the alleged compiler bug is fixed
#if defined(INEXPLICABLE_DYNAMIC_CAST)
  #define VARIANT_AS_TVARDATA(x) dynamic_cast<TVarData&>(x)
#else
  #define VARIANT_AS_TVARDATA(x) x
#endif

// InitVariant initializes the variant, and then clears the largest field in
// the union.  This is to ensure that uninitialized data there doesn't get
// interpreted as valid in certain cases, notably, when we cast variant
// objects around before they have been fully instantiated.  In the long
// run, we will do away with the casting and this function can skip
// initializing the union.
static inline void InitVariant(TVarData &vd)
{
    Varutils::VariantInit(vd);
    vd.VInt64 = 0;
}

namespace System
{
#if defined(VARIANT_AUTOMATION_SUPPORT)
  Variant __fastcall Variant::CreateObject(const String& ProgID)
  {
    return Variant(Comobj::CreateOleObject(const_cast<String&>(ProgID)));
  }

  Variant __fastcall Variant::GetActiveObject(const String& ProgID)
  {
    return Variant(Comobj::GetActiveOleObject(const_cast<String&>(ProgID)));
  }

  // Static ref. to be used for non-specified optional parameters
  //
  Variant& Variant::NoParam()
  {
    VariantError err;
    static Variant _noParam(err);
    _ASSERTE(_noParam.VType == VT_ERROR);
    _ASSERTE(V_ERROR(&_noParam) == DISP_E_PARAMNOTFOUND);
    return _noParam;
  }
#endif // VARIANT_AUTOMATION_SUPPORT

  // Static ref. used for empty Variants
  //
  Variant& Variant::Empty()
  {
    static Variant _empty;
    _ASSERTE(_empty.VType == varEmpty);
    return _empty;
  }

  // Ctr - From Variants
  __fastcall Variant::Variant()
  {
	InitVariant(VARIANT_AS_TVARDATA(*this));
  }

  __fastcall Variant::Variant(const Variant& rhs)
  {
    // Handle case where this == &rhs (Compiler messup)
    // NOTE: This copy *MUST* happen before the VARIANTINIT call
    //       because if the compiler calls with this=&rhs, we'll
    //       be wiping out our source!!
    char copy[sizeof(Variant)];
    memcpy(&copy, &rhs, sizeof(copy));

	InitVariant(VARIANT_AS_TVARDATA(*this));

    // Use assignment operator
    *this = *(reinterpret_cast<Variant*>(&copy));
  }

  __fastcall Variant::Variant(const TVarData& rhs)
  {
    char copy[sizeof(TVarData)];
    memcpy(&copy, &rhs, sizeof(copy));

	InitVariant(VARIANT_AS_TVARDATA(*this));

    *this = *(reinterpret_cast<Variant*>(&copy));
  }

#if defined(VARIANT_TVARIANT_SUPPORT)
  __fastcall Variant::Variant(const TVariant& rhs)
  {
    ::VariantInit(reinterpret_cast<VARIANTARG*>(this));
    ::VariantCopy(reinterpret_cast<VARIANTARG *>(this), const_cast<TVariant*>(&rhs));
  }
#endif

  inline void __fastcall Variant::SetType(uint16_t vt, bool init)
  {
      if (init)
				InitVariant(VARIANT_AS_TVARDATA(*this));
      else
      	Clear();
      VType = vt;
  }

  inline void __fastcall Variant::SetRefType(uint16_t vt, void *p, bool init)
  {
      SetType(vt|varByRef, init);
      VPointer = p;
  }

  // Ctr - From basic C++ types
  __fastcall Variant::Variant(const bool src)
  {
    SetType(varBoolean, true);
    VBoolean = src ? VARIANT_TRUE : VARIANT_FALSE;
  }

  __fastcall Variant::Variant(const char src)
  {
    SetType(varShortInt, true);
    VShortInt = src;
  }

  __fastcall Variant::Variant(const signed char src)
  {
    SetType(varShortInt, true);
    VShortInt = src;
  }

  __fastcall Variant::Variant(const unsigned char src)
  {
    SetType(varByte, true);
    VByte = src;
  }

  __fastcall Variant::Variant(const short src)
  {
    SetType(varSmallint, true);
    VSmallint = src;
  }

  __fastcall Variant::Variant(const unsigned short src)
  {
    SetType(varWord, true);
    VWord = src;
  }

  __fastcall Variant::Variant(const int src)
  {
    SetType(varInteger, true);
    VInteger = src;
  }

  __fastcall Variant::Variant(const unsigned int src)
  {
    SetType(varLongWord, true);
    VLongWord = src;
  }

  __fastcall Variant::Variant(const long src)
  {
    SetType(Variant_varLong, true);
    Variant_VLong = src;
  }

  __fastcall Variant::Variant(const unsigned long src)
  {
    SetType(Variant_varULong, true);
    Variant_VLong = src;
  }

  __fastcall Variant::Variant(const float src)
  {
    SetType(varSingle, true);
    VSingle = src;
  }

  __fastcall Variant::Variant(const double src)
  {
    SetType(varDouble, true);
    VDouble = src;
  }

  __fastcall Variant::Variant(const long double src)
  {
    // FIXME: why is this here?
    SetType(varDouble, true);
    VDouble = src;
  }

  __fastcall Variant::Variant(const __int64 src)
  {
    SetType(varInt64, true);
    VInt64 = src;
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  // Ctr - From OLE Structures
  __fastcall Variant::Variant(const CURRENCY& src)
  {
	  InitVariant(VARIANT_AS_TVARDATA(*this));
    SET_VTYPE_AND_VAR(CY, src);
  }

  __fastcall Variant::Variant(SAFEARRAY& src)
  {
	  InitVariant(VARIANT_AS_TVARDATA(*this));

    VARTYPE _vt;
    ::SafeArrayGetVartype(&src, &_vt);
    VType = VT_ARRAY|_vt;

    V_ARRAY(this) = &src;
  }

  __fastcall Variant::Variant(SAFEARRAY* src)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));

    VARTYPE _vt;
    ::SafeArrayGetVartype(src, &_vt);
    VType = VT_ARRAY|_vt;
 
    V_ARRAY(this) = src;
  }

  __fastcall Variant::Variant(VARIANT* src)
  {
    ::VariantInit(reinterpret_cast<VARIANTARG*>(this));

    // NOTE: We could hold on to the Variant by ref...
    /* i.e. SET_VTYPE_AND_VARREF(VARIANT, src); */

    // However, it safer to copy since only one level of indirection is allowed
    //
    ::VariantCopy(reinterpret_cast<VARIANTARG *>(this), src);
  }
#endif // VARIANT_NATIVE_SUPPORT

  // Ctr - From Utility classes
  // NOTE: This is not OLE compatible (i.e. True VARIANT cannot hold on to an
  //       MBCS string. You must ensure that this Variant is not sent to OLE
  //       in an Invoke call for example. The late-bound functions (Exec,
  //       OleProcedure, OleFunction etc.) exposed by the Variant class
  //       ensures that the string is widened. The code generated by importing
  //       TypeLibraries never utilizes AnsiString. So, in general, we should
  //       be safe.
  //
  __fastcall Variant::Variant(const AnsiString& src)
  {
    SetType(varString, true);
    VString = 0;
    (AnsiString&)VString = src;
  }

  __fastcall Variant::Variant(const Currency& src)
  {
    SetType(varCurrency, true);
    VCurrency = src;
  }

  __fastcall Variant::Variant(const TDateTime& src)
  {
    SetType(varDate, true);
    VDate = src;
  }

#if defined(VARIANT_ERROR_SUPPORT)
  __fastcall Variant::Variant(const VariantError& src)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));
    SET_VTYPE_AND_VAR(ERROR, src);
  }
#endif

  __fastcall Variant::Variant(const WideString& src)
  {
    SetType(varOleStr, true);
    (WideString&)VOleStr = src.Copy();
  }


  // Ctr - Asciiz Pointer
  // We currently treat 'const char*' as a string.
  // However, it could also be viewed as a character by reference!!!!
  __fastcall Variant::Variant(const char* src)
  {
    SetType(varString, true);
    (AnsiString&)VString = src;
  }

  __fastcall Variant::Variant(wchar_t* src)
  {
    SetType(varOleStr, true);
    (WideString&)VOleStr = src;
  }

#if defined(VARIANT_AUTOMATION_SUPPORT)
  __fastcall Variant::Variant(IDispatch* src)
  {
    SetType(varDispatch, true);
    if (src)
      src->AddRef();
    VDispatch = src;
  }

  __fastcall Variant::Variant(IUnknown* src)
  {
    SetType(varUnknown, true);
    if (src)
      src->AddRef();
    VUnknown = src;
  }
#endif	


  __fastcall Variant::Variant(signed char* src)
  {
    SetRefType(varShortInt, src, true);
  }

  __fastcall Variant::Variant(unsigned char* src)
  {
    SetRefType(varByte, src, true);
  }

  __fastcall Variant::Variant(short* src)
  {
    SetRefType(varSmallint, src, true);
  }

  __fastcall Variant::Variant(unsigned short* src)
  {
    SetRefType(varWord, src, true);
  }

  __fastcall Variant::Variant(int* src)
  {
    SetRefType(varInteger, src, true);
  }

  __fastcall Variant::Variant(unsigned int* src)
  {
    SetRefType(varLongWord, src, true);
  }

  __fastcall Variant::Variant(long* src)
  {
    SetRefType(Variant_varLong, src, true);
  }

  __fastcall Variant::Variant(unsigned long* src)
  {
    SetRefType(Variant_varULong, src, true);
  }

  __fastcall Variant::Variant(float* src)
  {
    SetRefType(varSingle, src, true);
  }

  __fastcall Variant::Variant(double* src)
  {
    SetRefType(varDouble, src, true);
  }

  __fastcall Variant::Variant(__int64* src)
  {
    SetRefType(varInt64, src, true);
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  __fastcall Variant::Variant(CURRENCY* src)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));
    SET_VTYPE_AND_VARREF(CY, src);
  }

  __fastcall Variant::Variant(SAFEARRAY** src)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));

    VARTYPE _vt;
    ::SafeArrayGetVartype(*src, &_vt);
    VType = VT_ARRAY|VT_BYREF|_vt;
    V_ARRAYREF(this) = src;
    SET_VTYPE_AND_VARREF(ARRAY, src);
  }
#endif // VARIANT_NATIVE_SUPPORT

#if defined(WIDECHAR_IS_WCHAR)
  __fastcall Variant::Variant(wchar_t** src)        // VT_BSTR|VT_BYREF
  {
    SetRefType(varOleStr, src, true);
  }
#endif

  // Ctr - Ref Utility classes
  __fastcall Variant::Variant(Currency* src)
  {
    SetRefType(varCurrency, src, true);
  }

  __fastcall Variant::Variant(TDateTime* src)
  {
    SetRefType(varDate, src, true);
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  __fastcall Variant::Variant(Variant* src)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));
    SET_VTYPE_AND_VARREF(VARIANT, reinterpret_cast<VARIANTARG*>(src));
  }
#endif

  // Ctr - Arrays
  // Construct a Variant array of type varType
  //
  // For example: Variant ArrayVar(OPENARRAY(int, (0, 0)), varVariant);
  //              Varaint ArrayVar(OpenArray<int>(0, 0)), OpenArrayCount<int>(0, 0).GetHigh(), varVariant);
  __fastcall Variant::Variant(const int* bounds, const int boundsSize, Word varType)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));
    *this = Variants::VarArrayCreate(bounds, boundsSize, varType);
  }

  // Construct a one dimensional Variant array of type varVariant
  // and fill with values
  __fastcall Variant::Variant(const Variant* values, const int valuesSize)
  {
		InitVariant(VARIANT_AS_TVARDATA(*this));
    *this = Variants::VarArrayOf(values, valuesSize);
  }

  __fastcall Variant::Variant(const System::DelphiInterface<IDispatch>& src)
  {
    SetType(varDispatch, true);
    if (src)
      src->AddRef();
    VDispatch = src;
  }

  // Dtr
  __fastcall Variant::~Variant()
  {
    Clear();
  }

  // Assignments
  //
  Variant& __fastcall Variant::operator =(const Variant& rhs)
  {
    Clear();
    Varhlpr::VariantCpy(rhs, *this);
    _ASSERTE(/* Dest */VType == /* source */rhs.VType);
    return *this;
  }

  Variant& __fastcall Variant::operator =(const bool rhs)
  {
    SetType(varBoolean, false);;
    VBoolean = rhs ? VARIANT_TRUE : VARIANT_FALSE;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const char rhs)
  {
    SetType(varShortInt, false);;
    VShortInt = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const signed char rhs)
  {
    SetType(varShortInt, false);;
    VShortInt = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const unsigned char rhs)
  {
    SetType(varByte, false);;
    VByte = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const short rhs)
  {
    SetType(varSmallint, false);;
    VSmallint = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const unsigned short rhs)
  {
    SetType(varWord, false);;
    VWord = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const int rhs)
  {
    SetType(varInteger, false);;
    VInteger = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const unsigned int rhs)
  {
    SetType(varLongWord, false);;
    VLongWord = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const long rhs)
  {
    SetType(Variant_varLong, false);;
    Variant_VLong = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const unsigned long rhs)
  {
    SetType(Variant_varULong, false);;
    Variant_VLong = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const float rhs)
  {
    SetType(varSingle, false);;
    VSingle = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const double rhs)
  {
    SetType(varDouble, false);;
    VDouble = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const __int64 rhs)
  {
    SetType(varInt64, false);;
    VInt64 = rhs;
    return *this;
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  Variant& __fastcall Variant::operator =(const CURRENCY& rhs)
  {
    Clear();
    SET_VTYPE_AND_VAR(CY, rhs);
    return *this;
  }

  Variant& __fastcall Variant::operator =(SAFEARRAY& rhs)
  {
    Clear();

    VARTYPE _vt;
    ::SafeArrayGetVartype(&rhs, &_vt);
    VType = VT_ARRAY|_vt;
    V_ARRAY(this) = &rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(SAFEARRAY* rhs)
  {
    Clear();
    VARTYPE _vt;
    ::SafeArrayGetVartype(rhs, &_vt);
    VType = VT_ARRAY|_vt;
    V_ARRAY(this) = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const VARIANT& rhs)
  {
    Clear();
    ::VariantCopy(reinterpret_cast<VARIANTARG *>(this), const_cast<VARIANT*>(&rhs));
    return *this;
  }
  
  Variant& __fastcall Variant::operator =(VARIANT *rhs)
  {
    Clear();

    // Can only have one level of indirection with VT_VARIANT
    //
    if (rhs && rhs->vt != VT_VARIANT && rhs->vt != (VT_VARIANT|VT_BYREF))
    {
      SET_VTYPE_AND_VARREF(VARIANT, rhs);
    }
    else
      ::VariantCopy(reinterpret_cast<VARIANTARG *>(this), rhs);
    return *this;
  }
#endif // VARIANT_NATIVE_SUPPORT

#if defined(VARIANT_TVARIANT_SUPPORT)
  Variant& __fastcall Variant::operator =(const TVariant& rhs)
  {
    Clear();
    ::VariantCopy(reinterpret_cast<VARIANTARG *>(this), const_cast<TVariant*>(&rhs));
    return *this;
  }

  Variant& __fastcall Variant::operator =(TVariant *rhs)
  {
    return this->operator=(static_cast<VARIANT*>(rhs));
  }

#endif

#if defined(WIDECHAR_IS_WCHAR)
  // NOTE: We assume the wchar_t* is a BSTR (i.e. a SysAllocString'ed pointer)
  Variant& __fastcall Variant::operator =(wchar_t* rhs)
  {
    SetType(varOleStr, false);
    VOleStr = rhs;
    return *this;
  }
#endif

#if defined(VARIANT_AUTOMATION_SUPPORT)
  Variant& __fastcall Variant::operator =(IUnknown* rhs)
  {
    if (rhs)
      rhs->AddRef();
    SetType(varUnknown, false);;
    VUnknown = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(IDispatch* rhs)
  {
    if (rhs)
      rhs->AddRef();
    SetType(varDispatch, false);;
    VDispatch = rhs;
    return *this;
  }
#endif

  Variant& __fastcall Variant::operator =(const AnsiString& rhs)
  {
    SetType(varString, false);;
    VString = 0;
    (AnsiString&)VString = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const Currency& rhs)
  {
    SetType(varCurrency, false);;
    VCurrency = rhs;
    return *this;
  }

  Variant& __fastcall Variant::operator =(const TDateTime& rhs)
  {
    SetType(varDate, false);;
    VDate = rhs;
    return *this;
  }

#if defined(VARIANT_ERROR_SUPPORT)
  Variant& __fastcall Variant::operator =(const VariantError& rhs)
  {
    Clear();
    SET_VTYPE_AND_VAR(ERROR, rhs);
    return *this;
  }
#endif

  Variant& __fastcall Variant::operator =(const WideString& src)
  {
    SetType(varOleStr, false);;
#if defined(WIDESTRING_IS_BSTR)
    VOleStr = src.Copy();
#else
    (WideString&)VOleStr = src;
#endif
    return *this;
  }

#if defined(VARIANT_AUTOMATION_SUPPORT)

/* do we need versions of this for IUnknown and IInterface? ---aph */

  Variant& __fastcall Variant::operator =(const System::DelphiInterface<IDispatch>& rhs)
  {
    // NOTE: Relies on fact that operat T*() of DelphiInterface does not AddRef!!
    return this->operator=(LPDISPATCH(rhs));
  }

#endif


  Variant& __fastcall Variant::operator =(const char* src)            // Treated as pointer Asciiz string
  {
    // this was changed to AnsiString in the linux branch, but I don't believe that
    // was correct as a general case.
#ifdef _Windows
    Clear();
    (*this) = WideString(src);
#else
    *this = AnsiString(src);
#endif
    return *this;
  }

  Variant& __fastcall Variant::operator =(signed char* src)
  {
    SetRefType(varShortInt, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(unsigned char* src)
  {
    SetRefType(varByte, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(short* src)
  {
    SetRefType(varSmallint, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(unsigned short* src)
  {
    SetRefType(varWord, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(int* src)
  {
    SetRefType(varInteger, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(unsigned int* src)
  {
    SetRefType(varLongWord, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(long* src)
  {
    SetRefType(Variant_varLong, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(unsigned long* src)
  {
    SetRefType(Variant_varULong, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(float* src)
  {
    SetRefType(varSingle, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(double* src)
  {
    SetRefType(varDouble, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(__int64* src)
  {
    SetRefType(varInt64, src, false);
    return *this;
  }

#ifdef VARIANT_NATIVE_SUPPORT
  Variant& __fastcall Variant::operator =(CURRENCY* src)
  {
    Clear();
    SET_VTYPE_AND_VARREF(CY, src);
    return *this;
  }

  Variant& __fastcall Variant::operator =(SAFEARRAY** src)
  {
    Clear();
    VARTYPE _vt;
    ::SafeArrayGetVartype(*src, &_vt);
    VType = VT_ARRAY|VT_BYREF|_vt;
    V_ARRAYREF(this) = src;
    return *this;
  }
#endif

#if defined(WIDECHAR_IS_WCHAR)
  Variant& __fastcall Variant::operator =(WideChar** src)
  {
    SetRefType(varOleStr, src, false);
    return *this;
  }
#endif

#if defined(VARIANT_AUTOMATION_SUPPORT)
  Variant& __fastcall Variant::operator =(IUnknown** src)
  {
    SetRefType(varUnknown, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(IDispatch** src)
  {
    SetRefType(varDispatch, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(IInterface** src)
  {
    SetRefType(varUnknown, src, false);
    return *this;
  }
#endif

  Variant& __fastcall Variant::operator =(Currency* src)
  {
    SetRefType(varCurrency, src, false);
    return *this;
  }

  Variant& __fastcall Variant::operator =(TDateTime* src)
  {
    SetRefType(varDate, src, false);
    return *this;
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  Variant& __fastcall Variant::operator =(Variant* src)
  {
    Clear();
    SET_VTYPE_AND_VARREF(VARIANT, reinterpret_cast<VARIANTARG*>(src));
    return *this;
  }
#endif


  Variant& __fastcall Variant::operator +=(const Variant& src)
  {
    Varhlpr::VariantAdd(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator -=(const Variant& src)
  {
    Varhlpr::VariantSub(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator *=(const Variant& src)
  {
    Varhlpr::VariantMul(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator /=(const Variant& src)
  {
    Varhlpr::VariantDiv(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator %=(const Variant& src)
  {
    Varhlpr::VariantMod(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator &=(const Variant& src)
  {
    Varhlpr::VariantAnd(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator |=(const Variant& src)
  {
    Varhlpr::VariantOr(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator ^=(const Variant& src)
  {
    Varhlpr::VariantXor(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator <<=(const Variant& src)
  {
    Varhlpr::VariantShl(src, *this);
    return *this;
  }

  Variant& __fastcall Variant::operator >>=(const Variant& src)
  {
    Varhlpr::VariantShr(src, *this);
    return *this;
  }

  bool __fastcall Variant::operator ==(const Variant& src) const
  {
    return Variants::VarCompareValue(*this, src) == vrEqual;
  }

  bool __fastcall Variant::operator !=(const Variant& src) const
  {
      return Variants::VarCompareValue(*this, src) == vrNotEqual;
  }

  bool __fastcall Variant::operator <(const Variant& rhs) const
  {
    // Handle some stuff on C++ side (BCB-40469, BCB-13561)
    //
    if (VType == rhs.VType)
    {
      switch (VType)
      {
        case varShortInt:   return VShortInt < rhs.VShortInt;
        case varByte:       return VByte     < rhs.VByte;
        case varSmallint:   return VSmallint < rhs.VSmallint;
        case varWord:       return VWord     < rhs.VWord;
        case varInteger:    return VInteger  < rhs.VInteger;
        case varLongWord:   return VLongWord < rhs.VLongWord;
	case varInt64:      return VInt64    < rhs.VInt64;
        case varSingle:     return VSingle   < rhs.VSingle;
        case varDouble:     return VDouble   < rhs.VDouble;
	default:            break;
      }
    }

    return Variants::VarCompareValue(*this, rhs) == vrLessThan;
  }

  bool __fastcall Variant::operator >(const Variant& rhs) const
  {
    // Handle some stuff on C++ side (BCB-40469, BCB-13561)
    //
    if (VType == rhs.VType)
    {
      switch (VType)
      {
        case varShortInt:   return VShortInt > rhs.VShortInt;
        case varByte:       return VByte     > rhs.VByte;
        case varSmallint:   return VSmallint > rhs.VSmallint;
        case varWord:       return VWord     > rhs.VWord;
        case varInteger:    return VInteger  > rhs.VInteger;
        case varLongWord:   return VLongWord > rhs.VLongWord;
	case varInt64:      return VInt64    > rhs.VInt64;
        case varSingle:     return VSingle   > rhs.VSingle;
        case varDouble:     return VDouble   > rhs.VDouble;
	default:            break;
      }
    }

    return Variants::VarCompareValue(*this, rhs) == vrGreaterThan;
  }


  bool __fastcall Variant::operator <=(const Variant& rhs) const
  {
    return !operator >(rhs);
  }

  bool __fastcall Variant::operator >=(const Variant& rhs) const
  {
    return !operator <(rhs);
  }

  Variant __fastcall Variant::operator +(const Variant& rhs) const
  {
    return Varhlpr::VariantAdd2(rhs, *this);
  }

  Variant __fastcall Variant::operator -(const Variant& rhs) const
  {
    return Varhlpr::VariantSub2(rhs, *this);
  }

  Variant __fastcall Variant::operator *(const Variant& rhs) const
  {
    return Varhlpr::VariantMul2(rhs, *this);
  }

  Variant __fastcall Variant::operator /(const Variant& rhs) const
  {
    return Varhlpr::VariantDiv2(rhs, *this);
  }

  Variant __fastcall Variant::operator %(const Variant& rhs) const
  {
    return Varhlpr::VariantMod2(rhs, *this);
  }

  Variant __fastcall Variant::operator &(const Variant& rhs) const
  {
    return Varhlpr::VariantAnd2(rhs, *this);
  }

  Variant __fastcall Variant::operator |(const Variant& rhs) const
  {
    return Varhlpr::VariantOr2(rhs, *this);
  }

  Variant __fastcall Variant::operator ^(const Variant& rhs) const
  {
    return Varhlpr::VariantXor2(rhs, *this);
  }

  Variant __fastcall Variant::operator <<(const Variant& rhs) const
  {
    return Varhlpr::VariantShl2(rhs, *this);
  }

  Variant __fastcall Variant::operator >>(const Variant& rhs) const
  {
    return Varhlpr::VariantShr2(rhs, *this);
  }

  Variant __fastcall Variant::operator -() const
  {
    return Varhlpr::VariantNeg(*this);
  }

  Variant __fastcall Variant::operator !() const
  {
    return Varhlpr::VariantNot(*this);
  }

  // Conversion operators

  __fastcall Variant::operator bool() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varBoolean);
    return tmp.VBoolean != VARIANT_FALSE;
  }

  __fastcall Variant::operator char() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varShortInt);
    return tmp.VShortInt;
  }

  __fastcall Variant::operator signed char() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varShortInt);
    return tmp.VShortInt;
  }

  __fastcall Variant::operator unsigned char() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varByte);
    return tmp.VByte;
  }

  __fastcall Variant::operator short() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varSmallint);
    return tmp.VSmallint;
  }

  __fastcall Variant::operator unsigned short() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varWord);
    return tmp.VWord;
  }

  __fastcall Variant::operator int() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varInteger);
    return tmp.VInteger;
  }

  __fastcall Variant::operator unsigned int() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varLongWord);
    return tmp.VLongWord;
  }

  __fastcall Variant::operator long() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, Variant_varLong);
    return tmp.Variant_VLong;
  }

  __fastcall Variant::operator unsigned long() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, Variant_varULong);
    return tmp.Variant_VLong;
  }

  __fastcall Variant::operator float() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varSingle);
    return tmp.VSingle;
  }

  __fastcall Variant::operator double() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varDouble);
    return tmp.VDouble;
  }

  __fastcall Variant::operator AnsiString() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varString);
    return AnsiString((AnsiString&)(tmp.VString));
  }

  __fastcall Variant::operator __int64() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varInt64);
    return tmp.VInt64;
  }
  __fastcall Variant::operator Currency() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varCurrency);
    return tmp.VCurrency;
  }

  __fastcall Variant::operator TDateTime() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varDate);
    return tmp.VDate;
  }

  __fastcall Variant::operator WideString() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varOleStr);
#if defined(WIDESTRING_IS_BSTR)
    return WideString::Copy(tmp.VOleStr);
#else
    return tmp.VOleStr;
#endif
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  __fastcall Variant::operator CURRENCY() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, VT_CY);
    return V_CY(&tmp);
  }

  __fastcall Variant::operator VARIANT()
  {
    VARIANT tmp;
    ::VariantInit(&tmp);

    // Handle case where 'Variant' contains non-standard MBCS string
    //
    if (Type() == varString)
    {
      V_BSTR(&tmp) = WideString(AnsiString(*this)).Detach();
      tmp.vt = VT_BSTR;
    }
    else
      ::VariantCopy(&tmp, reinterpret_cast<VARIANTARG*>(this));

    return tmp;
  }
#endif // VARIANT_NATIVE_SUPPORT
#ifdef VARIANT_TVARIANT_SUPPORT

  __fastcall Variant::operator TVariant()
  {
    return TVariant(*(reinterpret_cast<VARIANT*>(this)));
  }
#endif

#if defined(WIDECHAR_IS_WCHAR)
  __fastcall Variant::operator wchar_t*() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varOleStr);
#if defined(WIDESTRING_IS_BSTR)
    return WideString::Copy(tmp.VOleStr);
#else
    return tmp.VOleStr;
#endif
  }
#endif

#if defined(VARIANT_AUTOMATION_SUPPORT)
  __fastcall Variant::operator IDispatch*()
  {
    // Handle easy case right away
    //
    if (VType==VT_NULL || VType==VT_EMPTY)
      return 0;

    LPUNKNOWN  punk;
    LPDISPATCH disp= 0;
    Variant*   pVar= GetBaseVariant();

    // Get data out of Variant
    //
    switch(pVar->VType)
    {
      case VT_DISPATCH:
      case VT_DISPATCH|VT_BYREF:
        disp = (VType==VT_DISPATCH ? V_DISPATCH(pVar) : (*(V_DISPATCHREF(pVar))));
        if (disp)
          disp->AddRef();
        return disp;

      case VT_UNKNOWN:
      case VT_UNKNOWN|VT_BYREF:
        punk = (VType==VT_UNKNOWN ? V_UNKNOWN(pVar) : (*(V_UNKNOWNREF(pVar))));
        punk->QueryInterface(IID_IDispatch, (LPVOID*)&disp);
        return disp;

      default:
        Variant tmp;
        Varhlpr::VariantCast(*pVar, tmp, varDispatch);
        if (tmp.VDispatch)
          tmp.VDispatch->AddRef();
        return tmp.VDispatch;
    }
  }

  __fastcall Variant::operator IUnknown*()
  {
    // Handle easy case right away
    //
    if (VType==VT_NULL || VType==VT_EMPTY)
      return 0;

    LPDISPATCH disp;
    LPUNKNOWN  punk = 0;
    Variant*   pVar = GetBaseVariant();

    // Get Data out of Variant
    //
    switch(pVar->VType)
    {
      case VT_UNKNOWN:
      case VT_UNKNOWN|VT_BYREF:
        punk = (VType==VT_UNKNOWN ? V_UNKNOWN(pVar) : (*(V_UNKNOWNREF(pVar))));
        punk->AddRef();
        return punk;

      case VT_DISPATCH:
      case VT_DISPATCH|VT_BYREF:
        disp = (VType==VT_DISPATCH ? V_DISPATCH(pVar) : (*(V_DISPATCHREF(pVar))));
        if (disp)
          disp->QueryInterface(IID_IUnknown, (LPVOID*)&punk);
        return punk;

      // Hopefully, we'll never get here, but as last resort
      //
      default:
        Variant tmp;
        Varhlpr::VariantCast(tmp, *pVar, varUnknown);
        if (tmp.VUnknown)
          tmp.VUnknown->AddRef();
        return tmp.VUnknown;
    }
  }

  __fastcall Variant::operator IInterface*() 
  {
      IUnknown* retval = *this;
      return reinterpret_cast<IInterface*>(retval);
  }

#endif

  // By ref conversion operators

  void __fastcall Variant::CastError(uint16_t vt)
  {
    Variants::VarCastError(VType, vt);
  }

  __fastcall Variant::operator signed char*()
  {
    signed char *rc = static_cast<signed char *>(VPointer);
    if (VType != (varShortInt|varByRef))
    {
      if (VType == varShortInt)
	rc = &VShortInt;
      else
	CastError(varShortInt|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator unsigned char*()
  {
    unsigned char *rc = static_cast<unsigned char *>(VPointer);
    if (VType != (varByte|varByRef))
    {
      if (VType == varByte)
	rc = &VByte;
      else
	CastError(varByte|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator short*()
  {
    short *rc = static_cast<short *>(VPointer);
    if (VType != (varSmallint|varByRef))
    {
      if (VType == varSmallint)
	rc = &VSmallint;
      else
	CastError(varSmallint|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator unsigned short*()
  {
    unsigned short *rc = static_cast<unsigned short *>(VPointer);
    if (VType != (varWord|varByRef))
    {
      if (VType == varWord)
	rc = &VWord;
      else
	CastError(varWord|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator int*()
  {
    int *rc = static_cast<int *>(VPointer);
    if (VType != (varInteger|varByRef))
    {
      if (VType == varInteger)
	rc = &VInteger;
      else
	CastError(varInteger|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator unsigned int*()
  {
    unsigned int *rc = static_cast<unsigned int *>(VPointer);
    if (VType != (varLongWord|varByRef))
    {
      if (VType == varLongWord)
	rc = &VLongWord;
      else
	CastError(varLongWord|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator long*()
  {
    long *rc = static_cast<long *>(VPointer);
    if (VType != (Variant_varLong|varByRef))
    {
      if (VType == Variant_varLong)
	rc = reinterpret_cast<long*>(&Variant_VLong);
      else
	CastError(Variant_varLong|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator unsigned long*()
  {  
    unsigned long *rc = static_cast<unsigned long *>(VPointer);
    if (VType != (Variant_varULong|varByRef))
    {
      if (VType == Variant_varULong)
	rc = reinterpret_cast<unsigned long*>(&Variant_VULong);
      else
	CastError(Variant_varULong|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator float*()
  {
    float *rc = static_cast<float *>(VPointer);
    if (VType != (varSingle|varByRef))
    {
      if (VType == varSingle)
	rc = &VSingle;
      else
	CastError(varSingle|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator double*()
  {
    double *rc = static_cast<double *>(VPointer);
    if (VType != (varDouble|varByRef))
    {
      if (VType == varDouble)
	rc = &VDouble;
      else
	CastError(varDouble|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator Currency*()
  {
    Currency *rc = static_cast<Currency *>(VPointer);
    if (VType != (varCurrency|varByRef))
    {
      if (VType == varCurrency)
	rc = static_cast<Currency*>(&VCurrency);
      else
	CastError(varCurrency|varByRef);
    }
    return rc;
  }

  __fastcall Variant::operator TDateTime*()
  {
    TDateTime *rc = static_cast<TDateTime *>(VPointer);
    if (VType != (varDate|varByRef))
    {
      if (VType == varDate)
	rc = static_cast<TDateTime*>(&VDate);
      else
	CastError(varDate|varByRef);
    }
    return rc;
  }

#if defined(WIDECHAR_IS_WCHAR)
  __fastcall Variant::operator wchar_t**()
  {
    WideChar** rc = static_cast<wchar_t **>(VPointer);
    if (VType != (varOleStr|varByRef))
    {
      if (VType == varOleStr)
	rc = &VOleStr;
      else
	CastError(varOleStr|varByRef);
    }
    return rc;
  }
#endif

#if defined(VARIANT_AUTOMATION_SUPPORT)
  __fastcall Variant::operator VARIANT*()
  {
    return reinterpret_cast<VARIANT*>(GetBaseVariant());
  }

#endif
#if defined(VARIANT_TVARIANT_SUPPORT)
  __fastcall Variant::operator TVariant*()
  {
    return reinterpret_cast<TVariant*>((VARIANT*)(*this));
  }
#endif

  void __fastcall Variant::SetError(const HResult err)
  {
    SetType(varError, false);;
    VError = err;
  }

  HResult __fastcall Variant::GetError() const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varError);
    return tmp.VError;
  }

#if defined(VARIANT_NATIVE_SUPPORT)
  // Returns pointer to base Variant type when Variant holds other Variant
  //
  Variant* __fastcall Variant::GetBaseVariant()
  {
    Variant *pVar = this;

    // NOTE: Technically there could only be one level of indirection for VT_VARIANT
    //       Additionally, VT_VARIANT should always be used in combination with VT_BYREF
    //       However, it does not hurt to catch multiple indirection or check a simple
    //       VT_VARIANT VARTYPE. Never know what's being packed and sent down out there
    //
    while (((pVar->VType == VT_VARIANT) || (pVar->VType == (VT_VARIANT|VT_BYREF))) && (V_VARIANTREF(pVar)))
      pVar = reinterpret_cast<Variant*>(V_VARIANTREF(pVar));
    return pVar;
  }
#endif

  Variant& __fastcall Variant::ChangeType(int varType)
  {
    Variant tmp;
    Varhlpr::VariantCast(tmp, *this, varType);
    return *this = tmp;
  }

  Variant __fastcall Variant::AsType(int varType) const
  {
    Variant tmp;
    Varhlpr::VariantCast(*this, tmp, varType);
    return tmp;
  }

  Variant __fastcall Variant::Sanitized() const
  {
#if defined(VARIANT_NATIVE_SUPPORT)
    Variant tmp;
    // A VARIANT abomination!!
    if (tmp.VType == varString)
    {
      tmp = WideString(AnsiString(*this)).Detach();
    }
    else
    {
      tmp = *this;
    }
    return tmp;
#else
    return *this;
#endif
  }

  void __fastcall Variant::Clear()
  {
    Varhlpr::VariantClear(*this);
  }

  int __fastcall Variant::Type() const
  {
    return Variants::VarType(*this);
  }

  bool __fastcall Variant::IsNull() const
  {
    return Variants::VarIsNull(*this);
  }

  bool __fastcall Variant::IsEmpty() const
  {
    return Variants::VarIsEmpty(*this);
  }

  bool __fastcall Variant::IsArray() const
  {
    return Variants::VarIsArray(*this);
  }

  int __fastcall Variant::ArrayDimCount() const
  {
    return Variants::VarArrayDimCount(*this);
  }

  int __fastcall Variant::ArrayLowBound(const int dim) const
  {
    return Variants::VarArrayLowBound(*this, dim);
  }

  int __fastcall Variant::ArrayHighBound(const int dim) const
  {
    return Variants::VarArrayHighBound(*this, dim);
  }

  void __fastcall Variant::ArrayRedim(int highBound)
  {
    Varhlpr::VariantArrayRedim(*this, highBound);
  }

  Pointer __fastcall Variant::ArrayLock()
  {
    return Variants::VarArrayLock(*this);
  }

  void    __fastcall Variant::ArrayUnlock()
  {
    Variants::VarArrayUnlock(*this);
  }

#if defined VARIANT_AUTOMATION_SUPPORT
  Variant& __fastcall Variant::operator [](const int idx)
  {
    // Only use this function for arrays of type Variant!
    //
    if (!IsArray() || idx < ArrayLowBound() || idx > ArrayHighBound())
      throw EVariantError(sVarRangeArray);

    Variant* array((Variant*)ArrayLock());
    Variant* v(array + idx);
    ArrayUnlock();
    return *v;
  }
#endif

  Variant __fastcall Variant::GetElement(const int i1) const
  {
    return Varhlpr::VariantGetElement(*this, i1);
  }

  Variant __fastcall Variant::GetElement(const int i1, const int i2) const
  {
    return Varhlpr::VariantGetElement(*this, i1, i2);
  }

  Variant __fastcall Variant::GetElement(const int i1, const int i2, const int i3) const
  {
    return Varhlpr::VariantGetElement(*this, i1, i2, i3);
  }

  Variant __fastcall Variant::GetElement(const int i1, const int i2, const int i3, const int i4) const
  {
    return Varhlpr::VariantGetElement(*this, i1, i2, i3, i4);
  }

  Variant __fastcall Variant::GetElement(const int i1, const int i2, const int i3, const int i4, const int i5) const
  {
    return Varhlpr::VariantGetElement(*this, i1, i2, i3, i4, i5);
  }

  void __fastcall Variant::PutElement(const Variant& data, const int i1)
  {
    return Varhlpr::VariantPutElement(*this, data, i1);
  }

  void __fastcall Variant::PutElement(const Variant& data, const int i1, const int i2)
  {
    return Varhlpr::VariantPutElement(*this, data, i1, i2);
  }

  void __fastcall Variant::PutElement(const Variant& data, const int i1, const int i2, const int i3)
  {
    return Varhlpr::VariantPutElement(*this, data, i1, i2, i3);
  }

  void __fastcall Variant::PutElement(const Variant& data, const int i1, const int i2, const int i3, const int i4)
  {
    return Varhlpr::VariantPutElement(*this, data, i1, i2, i3, i4);
  }

  void __fastcall Variant::PutElement(const Variant& data, const int i1, const int i2, const int i3, const int i4, const int i5)
  {
    return Varhlpr::VariantPutElement(*this, data, i1, i2, i3, i4, i5);
  }

#if defined(VARIANT_AUTOMATION_SUPPORT)
  Variant __fastcall Variant::Exec(AutoCmd& cmd, Integer) const
  {
    //Result
    Variant tmp;
    Variant* ptmp = 0;

    if (cmd.RequestResult())
      ptmp = &tmp;

    //construct a call descriptor
    TCallDesc callDesc;
    TCallDesc* pcallDesc = &callDesc;

    // set calltype, argcount, named arg count
    callDesc.CallType      = cmd.GetCallType();
    callDesc.ArgCount      = cmd.GetArgCount();
    callDesc.NamedArgCount = cmd.GetNamedArgCount();

    // fill in arg types for named args
    for (Byte i = 0; i < callDesc.NamedArgCount; i++)
    {
      int argType = cmd.GetNamedArgType(i);
      if (argType == varString)
        callDesc.ArgTypes[i] = varStrArg;
      else if (argType == (varString | varByRef))
        callDesc.ArgTypes[i] = varStrArg + 128;
      else
      {
        callDesc.ArgTypes[i] = (Byte)(argType & varTypeMask);
        callDesc.ArgTypes[i] += (Byte)((argType & varByRef) ? 128 : 0);
      }
    }

    // fill in arg types for un-named args
    for (Byte i = callDesc.NamedArgCount; i < callDesc.ArgCount; i++)
    {
      int argType = cmd.GetArgType((Byte)(i-callDesc.NamedArgCount));
      if (argType == varString)
        callDesc.ArgTypes[i] = varStrArg;
      else if (argType == (varString | varByRef))
        callDesc.ArgTypes[i] = varStrArg + 128;
      else
      {
        callDesc.ArgTypes[i] = (Byte)(argType & varTypeMask);
        callDesc.ArgTypes[i] += (Byte)((argType & varByRef) ? 128 : 0);
      }
    }

    // get ptr that points after all argtypes
    char* p = (char*) &callDesc.ArgTypes[callDesc.ArgCount];

    // fill in the name of the cmd
    p = stpcpy(p, (char*)cmd.GetName().c_str());

    // fill in names of named args
    for (Byte i = 0; i < callDesc.NamedArgCount; i++)
      p = stpcpy(p+1, (char*)cmd.GetNamedParmName(i).c_str());

    // fill an array of values/addresses of named args (makes asm easier)
    void* namedParms[MaxDispArgs*2];
    void* namedParmsPtr = &namedParms;
    Byte namedCursor = 0;
    for (Byte i = 0; i < callDesc.NamedArgCount; i++)
    {
      Variant* v = &cmd.GetNamedParm(i);
      int argType= cmd.GetNamedArgType(i) & varTypeMask;
      bool byRef = cmd.GetNamedArgType(i) & varByRef;
      if (!byRef)
      {
        switch (argType)
        {
        case varDouble:
        case varDate:
        case varCurrency:
          namedParms[namedCursor++] = reinterpret_cast<void*>(v->VInteger);  // other half
          namedParms[namedCursor++] = reinterpret_cast<void*>(*((&v->VInteger) + 1));     //half
          break;
        case varSingle:
        case varDispatch:
        case varInteger:
        case varBoolean:
        case varOleStr:
        case varUnknown:
          namedParms[namedCursor++] = reinterpret_cast<void*>(v->VInteger);  // pick 1 (union)
          break;
        case varSmallint:
          namedParms[namedCursor++] = reinterpret_cast<void*>((int)v->VSmallint);
          break;
        case varByte:
          namedParms[namedCursor++] = reinterpret_cast<void*>((int)v->VByte);
          break;
        case varVariant:
          namedParms[namedCursor++] = v;
          break;
        }
      }
      else // byRef
      {
          namedParms[namedCursor++] = v->VPointer;
      }
    }
    // fill an array of values/addresses of un-named args (makes asm easier)
    void* parms[MaxDispArgs*2];
    void* parmsPtr = &parms;
    Byte cursor = 0;
    for (Byte i = 0; i < callDesc.ArgCount - callDesc.NamedArgCount; i++)
    {
      Variant* v = &cmd.GetParm(i);
      int argType= cmd.GetArgType(i) & varTypeMask;
      bool byRef = cmd.GetArgType(i) & varByRef;
      if (!byRef)
      {
        switch  (argType)
        {
        case varDouble:
        case varDate:
        case varCurrency:
          parms[cursor++] = reinterpret_cast<void*>(v->VInteger);  // other half
          parms[cursor++] = reinterpret_cast<void*>(*((&v->VInteger) + 1)); //half
          break;
        case varSingle:
        case varDispatch:
        case varInteger:
        case varBoolean:
        case varOleStr:
        case varUnknown:
          parms[cursor++] = reinterpret_cast<void*>(v->VInteger);  // pick 1 (union)
          break;
        case varSmallint:
          parms[cursor++] = reinterpret_cast<void*>((int)v->VSmallint);
          break;
        case varByte:
          parms[cursor++] = reinterpret_cast<void*>((int)v->VByte);
          break;
        case varVariant:
          parms[cursor++] = v;
          break;
        }
      }
      else // byRef
      {
          parms[cursor++] = v->VPointer;
      }
    }

    _EDX  = 0x0;                          // xor  edx, edx
    _DL   = cursor;                       // mov  dl, cursor
    _EDX -= 1;                            // dec  edx
    _EDX <<= 2;                           // shl  edx, 2
    _EAX  = (unsigned long)parmsPtr;      // mov  eax, parmsPtr
    _EDX += _EAX;                         // add  edx, eax
    _CL   = cursor;                       // mov  cl, cursor

    while (--_CL > 0)                     // dec  cl - while (ecx > 0)
    {
      _EAX = *((unsigned long*)_EDX);     // mov  eax, [edx]
      __emit__(0x50);                     // push eax
      _EDX -= 4;                          // sub  edx, 4
    }

    _EDX  = 0x0;                          // xor  edx, edx
    _DL   = namedCursor;                  // mov  dl, namedCursor
    _EDX -= 1;                            // dec  edx
    _EDX <<= 2;                           // shl  edx, 2
    _EAX  = (unsigned long)namedParmsPtr; // mov  eax, namedParmsPtr
    _EDX += _EAX;                         // add  edx, eax
    _CL   = namedCursor;                  // mov  cl, namedCursor

    while (--_CL > 0)                     // dec  cl - while (ecx > 0)
    {
      _EAX = *((unsigned long*)_EDX);     // mov  eax, [edx]
      __emit__(0x50);                     // push eax
      _EDX -= 4;                          // sub  edx, 4
    }

#if 0 || defined(USE_VCLHLPR_PAS)
    (*Varhlpr::TVarDispProc(Variants::VarDispProc))(ptmp, *this, pcallDesc);
#else
    typedef void __cdecl (*TVarDispProc)(System::PVariant Result,
                                         const Variant &Instance,
                                         System::PCallDesc CallDesc,
                                         void* Params);
    (*TVarDispProc(Variants::VarDispProc))(ptmp, *this, pcallDesc, parms);
#endif

    // NOTE: C++ Compiler cleans up 12 bytes for above 3 parameters.
    //       We only need to clean the extra parameters we pushed

    _ECX  = 0;                            // xor  ecx, ecx
    _CL   = cursor;                       // mov  cl, cursor
    _CL  += namedCursor;                  // add  cl, namedcursor
    _ECX *= 4;                            // shl  ecx, 2
    _ESP += _ECX;                         // add  esp, ecx


/* Original assembly code that required TASM
    asm
    {
      extrn   @System@@DispInvoke$qv:near
      xor     edx, edx
      mov     dl, cursor
      dec     edx
      imul    edx, 4
      add     edx, parmsPtr
      mov     cl, cursor
      @@0:
      dec     cl
      test    cl,  cl
      jl      @@1
      mov     eax, [edx]
      push    eax
      sub     edx, 4
      jmp     @@0

      @@1:
      xor     edx, edx
      mov     dl, namedCursor
      dec     edx
      imul    edx, 4
      add     edx, namedParmsPtr
      mov     cl, namedCursor
      @@2:
      dec     cl
      test    cl,  cl
      jl      @@3
      mov     eax, [edx]
      push    eax
      sub     edx, 4
      jmp     @@2
      @@3:

      push    pcallDesc
      push    this
      push    ptmp

      call    @System@@DispInvoke$qv

      xor     ecx, ecx
      mov     cl, cursor
      add     cl, namedCursor
      imul    ecx, 4
      add     ecx, 12
      add     esp, ecx
    }
*/

    // if no result is returned, return a true
    if (!cmd.RequestResult())
      tmp = true;

    return tmp;
  }


  void Variant::OleProcedure(const String& name, TAutoArgsBase* args)
  {
    // Bind to IDispatch in this Variant
    //
    TAutoDriver<IDispatch> disp;
    disp.Bind(*this /* operator LPDISPATCH() AddRef()s already */, false);

    // Look up the dispid of the name passed
    //
    DISPID id;
    OleCheck(disp.GetIDsOfNames(WideString(name).data(), id));

    // Do Invoke
    //
    if (args)
      OleCheck(disp.OleProcedure(id, *args));
    else
      OleCheck(disp.OleProcedure(id));
  }

  Variant Variant::OleFunction(const String& name, TAutoArgsBase* args)
  {
    // Bind to IDispatch in this Variant
    //
    TAutoDriver<IDispatch> disp;
    disp.Bind(*this /* operator LPDISPATCH() AddRef()s already */, false);

    // Look up the dispid of the name passed
    //
    DISPID id;
    OleCheck(disp.GetIDsOfNames(WideString(name).data(), id));

    // OleFunctions need args array since it returns value
    //
    TAutoArgs<0> _a;
    if (!args)
      args = &_a;

    // Do Invoke
    //
    OleCheck(disp.OleFunction(id, *args));
    return Variant(args->GetRetVariant());
  }

  Variant Variant::OlePropertyGet(const String& name, TAutoArgsBase* args)
  {
    // Bind to IDispatch in this Variant
    //
    TAutoDriver<IDispatch> disp;
    disp.Bind(*this /* operator LPDISPATCH() AddRef()s already */, false);

    // Look up the dispid of the name passed
    //
    DISPID id;
    OleCheck(disp.GetIDsOfNames(WideString(name).data(), id));

    // OlePropertyGets need args array since it returns value
    //
    TAutoArgs<0> _a;
    if (!args)
      args = &_a;

    // Do Invoke
    //
    OleCheck(disp.OlePropertyGet(id, *args));
    return Variant(args->GetRetVariant());
  }

  void Variant::OlePropertySet(const String& name, TAutoArgsBase& args)
  {

    // Bind to IDispatch in this Variant
    //
    TAutoDriver<IDispatch> disp;
    disp.Bind(*this /* operator LPDISPATCH() AddRef()s already */, false);

    // Look up the dispid of the name passed
    //
    DISPID id;
    OleCheck(disp.GetIDsOfNames(WideString(name).data(), id));

    // Do Invoke
    //
    OleCheck(disp.OlePropertyPut(id, args));
  }


  // AutoCmd
  //
  AutoCmd::AutoCmd(const String& name): Name(name)
  {}

  AutoCmd::AutoCmd(const AutoCmd& src): Name(src.Name),
                                        Parms(src.Parms),
                                        ParmTypes(src.ParmTypes),
                                        NamedParms(src.NamedParms),
                                        NamedParmTypes(src.NamedParmTypes),
                                        NamedParmNames(src.NamedParmNames)
  {}

  AutoCmd::~AutoCmd()
  {}

  AutoCmd& AutoCmd::SetName(const String& name)
  {
    Name = name;
    return *this;
  }

  AutoCmd& AutoCmd::Clear()
  {
    ClearName();
    ClearArgs();
    return *this;
  }

  AutoCmd& AutoCmd::ClearName()
  {
    SetName("");
    return *this;
  }

  AutoCmd& AutoCmd::ClearArgs()
  {
    Parms.Clear();
    ParmTypes.Clear();

    NamedParms.Clear();
    NamedParmTypes.Clear();
    NamedParmNames.Clear();

    return *this;
  }

  int AutoCmd::GetArgType(const Byte idx) const
  {
    if (ParmTypes.IsEmpty() || ParmTypes.ArrayHighBound() < idx)
      throw EVariantError(sAcGatRange);
    return ParmTypes.GetElement(idx);
  }

  int AutoCmd::GetNamedArgType(const Byte idx) const
  {
    if (NamedParmTypes.IsEmpty() || NamedParmTypes.ArrayHighBound() < idx)
      throw EVariantError(sAcGnatRange);
    return NamedParmTypes.GetElement(idx);
  }

  Byte AutoCmd::GetArgCount() const
  {
    int count = GetNamedArgCount();
    if (!Parms.IsEmpty())
      count += Parms.ArrayHighBound() + 1;
    return (Byte) count;
  }

  Byte AutoCmd::GetNamedArgCount() const
  {
    int count = 0;
    if (!NamedParms.IsEmpty())
      count += NamedParms.ArrayHighBound() + 1;
    return (Byte)count;
  }

  Variant& AutoCmd::GetParm(const Byte idx)
  {
    if (Parms.IsEmpty() || Parms.ArrayHighBound() < idx)
      throw EVariantError(sAcGpRange);
    return Parms[idx];
  }

  Variant& AutoCmd::GetNamedParm(const Byte idx)
  {
    if (NamedParms.IsEmpty() || NamedParms.ArrayHighBound() < idx)
      throw EVariantError(sAcGnpRange);
    return NamedParms[idx];
  }

  String AutoCmd::GetNamedParmName(const Byte idx) const
  {
    if (NamedParms.IsEmpty() || NamedParms.ArrayHighBound() < idx)
      throw EVariantError(sAcGnpnRange);
    return NamedParmNames.GetElement(idx);
  }

  void AutoCmd::AddElement()
  {
    if (Parms.IsEmpty())
    {
      Parms = Variant(OPENARRAY(int, (0, 0)), varVariant);
      _ASSERTE(Parms.VType == (VT_ARRAY|VT_VARIANT));
      ParmTypes = Variant(OPENARRAY(int, (0, 0)), varInteger);
      _ASSERTE(ParmTypes.VType == (VT_ARRAY|VT_I4));
    }
    else
    {
      Parms.ArrayRedim(Parms.ArrayHighBound()+1);
      ParmTypes.ArrayRedim(ParmTypes.ArrayHighBound()+1);
    }
  }

  AutoCmd& AutoCmd::operator <<(const Variant& v)
  {
    AddElement();

    // Handle case where Variant contains a non-Automation compatible AnsiString
    Variant tmp(v);
    if (tmp.VType == varString)
      tmp.ChangeType(varOleStr);
    Parms.PutElement(tmp, Parms.ArrayHighBound());
    ParmTypes.PutElement(tmp.Type(), ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const short arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varSmallint, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const int arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varInteger, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const float arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varSingle, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const double arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varDouble, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const Currency arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varCurrency, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const TDateTime arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varDate, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const bool arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varBoolean, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const WordBool arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varBoolean, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const Byte arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varByte, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(const AnsiString& arg)
  {
    AddElement();
    // NOTE: AnsiString is converted to BSTR
    Parms.PutElement(WideString(arg).Detach(), Parms.ArrayHighBound());
    ParmTypes.PutElement(varOleStr, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(IDispatch* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varDispatch, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(wchar_t* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varOleStr, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(IUnknown* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varUnknown, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(Variant* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varVariant | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(short* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varSmallint | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(int* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varInteger | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(float* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varSingle | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(double* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varDouble | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(Currency* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varCurrency | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(TDateTime* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varDate | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(WordBool* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varBoolean | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(Byte* arg)
  {
    AddElement();
    Parms.PutElement(arg, Parms.ArrayHighBound());
    ParmTypes.PutElement(varByte | varByRef, ParmTypes.ArrayHighBound());
    return *this;
  }

  AutoCmd& AutoCmd::operator <<(AnsiString* arg)
  {
    // Automation Server does not support the non-OLE MBCS string type.
    // Hence, we turn the string into a plain string
    return this->operator << (*arg);
  }

  AutoCmd& AutoCmd::operator <<(const NamedParm& np)
  {
    if (NamedParms.IsEmpty())
    {
      NamedParms     = Variant(OPENARRAY(int, (0, 0)), varVariant);
      NamedParmTypes = Variant(OPENARRAY(int, (0, 0)), varInteger);
      NamedParmNames = Variant(OPENARRAY(int, (0, 0)), varVariant);
    }
    else
    {
      NamedParms.ArrayRedim(NamedParms.ArrayHighBound()+1);
      NamedParmTypes.ArrayRedim(NamedParmTypes.ArrayHighBound()+1);
      NamedParmNames.ArrayRedim(NamedParmNames.ArrayHighBound()+1);
    }

    NamedParmNames.PutElement(np.GetParmName(), NamedParmNames.ArrayHighBound());
    NamedParmTypes.PutElement(np.GetType(), NamedParmTypes.ArrayHighBound());
    NamedParms.PutElement(np.GetParm(), NamedParms.ArrayHighBound());

    return *this;
  }
#endif // VARIANT_AUTOMATION_SUPPORT
} // namespace System

